<?php

namespace Tests\Feature;

use App\Models\Booking;
use App\Models\Service;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProviderApprovalTest extends TestCase
{
    use RefreshDatabase;

    public function test_provider_can_approve_booking(): void
    {
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'provider']);
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'customer']);

        $provider = User::factory()->create();
        $provider->assignRole('provider');
        $customer = User::factory()->create();
        $customer->assignRole('customer');
        $service = Service::factory()->create(['user_id' => $provider->id, 'booking_mode' => 'approval_required']);

        $booking = Booking::create([
            'service_id' => $service->id,
            'customer_id' => $customer->id,
            'provider_id' => $provider->id,
            'status' => 'pending_provider_approval',
            'booking_mode' => 'approval_required',
            'scheduling_type' => 'fixed_datetime',
            'delivery_mode' => 'online',
            'amount' => 100,
            'currency' => 'USD',
        ]);

        $response = $this->actingAs($provider)->post(route('bookings.approve', $booking));
        $response->assertRedirect();
        $this->assertEquals('confirmed', $booking->refresh()->status);
    }
}
