<?php

namespace Tests\Feature;

use App\Models\Service;
use App\Models\User;
use App\Services\AvailabilityService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class AvailabilityApiTest extends TestCase
{
    use RefreshDatabase;

    public function test_can_fetch_slots()
    {
        $service = Service::factory()->create(['duration_minutes' => 30]);
        $service->availabilityRules()->create([
            'user_id' => $service->user_id,
            'day_of_week' => now()->dayOfWeek,
            'start_time' => '09:00',
            'end_time' => '11:00',
            'timezone' => 'UTC',
            'is_default' => true,
        ]);

        $user = User::factory()->create();

        $response = $this->actingAs($user)->getJson(route('availability.slots', ['service' => $service->id]));

        $response->assertOk();
        $response->assertJsonStructure(['service_id', 'slots']);
    }
}
