<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\InstallController;
use App\Http\Controllers\ProviderDashboardController;
use App\Http\Controllers\CustomerDashboardController;
use App\Http\Controllers\AvailabilityController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\BookingActionController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\CalendarController;
use App\Http\Controllers\DisputeController;
use App\Http\Controllers\PageController;
use Illuminate\Support\Facades\Route;

Route::prefix('install')->name('install.')->group(function () {
    Route::get('/', [InstallController::class, 'welcome'])->name('welcome');
    Route::post('/database/test', [InstallController::class, 'testDatabase'])->name('database.test');
    Route::post('/database/save', [InstallController::class, 'saveDatabase'])->name('database.save');
    Route::post('/migrate', [InstallController::class, 'migrate'])->name('migrate');
    Route::post('/settings', [InstallController::class, 'saveSettings'])->name('settings');
    Route::post('/gateways', [InstallController::class, 'saveGateways'])->name('gateways');
    Route::post('/finish', [InstallController::class, 'finish'])->name('finish');
});

Route::get('/', [PageController::class, 'home'])->name('home');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware(['auth', 'role:customer'])->group(function () {
    Route::get('/customer', [CustomerDashboardController::class, 'index'])->name('customer.dashboard');
    Route::post('/services/{service}/book', [ServiceController::class, 'book'])->name('services.book');
    Route::get('/bookings/{booking}/pay', [PaymentController::class, 'show'])->name('bookings.pay');
    Route::post('/bookings/{booking}/pay', [PaymentController::class, 'process'])->name('bookings.pay.process');
    Route::get('/bookings/{booking}/payment-status', fn($booking) => view('payments.status', ['booking' => \App\Models\Booking::findOrFail($booking)]))->name('bookings.payment.status');
    Route::get('/bookings/{booking}/messages', [MessageController::class, 'index'])->name('bookings.messages');
    Route::post('/bookings/{booking}/messages', [MessageController::class, 'store'])->name('bookings.messages.store');
    Route::post('/bookings/{booking}/cancel', [BookingActionController::class, 'cancel'])->name('bookings.cancel');
    Route::post('/bookings/{booking}/reschedule', [BookingActionController::class, 'reschedule'])->name('bookings.reschedule');
    Route::post('/bookings/{booking}/proposal/accept', [BookingActionController::class, 'acceptProposal'])->name('bookings.proposal.accept');
    Route::post('/bookings/{booking}/proposal/decline', [BookingActionController::class, 'declineProposal'])->name('bookings.proposal.decline');
});

Route::middleware(['auth', 'role:provider'])->group(function () {
    Route::get('/provider', [ProviderDashboardController::class, 'index'])->name('provider.dashboard');
    Route::post('/bookings/{booking}/approve', [BookingActionController::class, 'approve'])->name('bookings.approve');
    Route::post('/bookings/{booking}/reject', [BookingActionController::class, 'reject'])->name('bookings.reject');
    Route::get('/bookings/{booking}/messages', [MessageController::class, 'index'])->name('provider.bookings.messages');
    Route::post('/bookings/{booking}/messages', [MessageController::class, 'store'])->name('provider.bookings.messages.store');
    Route::get('/provider/calendar/connect', [CalendarController::class, 'connect'])->name('provider.calendar.connect');
    Route::post('/provider/calendar/token', [CalendarController::class, 'storeToken'])->name('provider.calendar.token');
    Route::get('/provider/calendar/callback', [CalendarController::class, 'callback'])->name('provider.calendar.callback');
    Route::post('/bookings/{booking}/proposal', [BookingActionController::class, 'propose'])->name('bookings.proposal');
});

Route::middleware(['auth', 'role:customer|provider'])->group(function () {
    Route::post('/bookings/{booking}/disputes', [DisputeController::class, 'store'])->name('bookings.disputes.store');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/api/availability/{service}', [AvailabilityController::class, 'slots'])->name('availability.slots');
    Route::get('/services', [ServiceController::class, 'index'])->name('services.index');
    Route::get('/services/{service}', [ServiceController::class, 'show'])->name('services.show');
});

Route::get('/pages/{slug}', [PageController::class, 'show'])->name('pages.show');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
