<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Services') }}
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid md:grid-cols-3 gap-4">
                @foreach($services as $service)
                    <a href="{{ route('services.show', $service) }}" class="block border rounded-lg p-4 bg-white shadow-sm hover:shadow">
                        <p class="text-sm text-gray-500">{{ $service->category?->name }}</p>
                        <p class="font-semibold text-lg">{{ $service->title }}</p>
                        <p class="text-sm text-gray-600 mt-1">{{ Str::limit($service->description, 80) }}</p>
                        <p class="text-sm text-gray-600 mt-2">${{ number_format($service->base_price, 2) }} {{ $service->currency }}</p>
                        <p class="text-xs text-gray-500">Mode: {{ $service->booking_mode }} · {{ $service->delivery_mode }}</p>
                    </a>
                @endforeach
            </div>
            <div class="mt-6">
                {{ $services->links() }}
            </div>
        </div>
    </div>
</x-app-layout>
