@component('mail::message')
# Booking Updated

Booking **#{{ $booking->id }}** changed from **{{ $from }}** to **{{ $to }}**.

@component('mail::panel')
Service: {{ $booking->service?->title }}  
Amount: ${{ number_format($booking->amount, 2) }} {{ $booking->currency }}  
Scheduled: {{ optional($booking->scheduled_start)->toDayDateTimeString() }}
@endcomponent

@component('mail::button', ['url' => $url])
View Booking
@endcomponent

Thanks,<br>
{{ config('app.name') }}
@endcomponent
