@php
    /** @var \Illuminate\Support\Collection|\App\Models\DisputeEvent[] $events */
    use Illuminate\Support\Facades\Storage;
@endphp
<div class="space-y-4">
    @forelse($events as $event)
        <div class="relative rounded-lg border border-gray-100 bg-white/70 p-4 shadow-sm">
            <div class="flex items-center justify-between gap-3">
                <div class="flex items-center gap-3">
                    <span class="h-2 w-2 rounded-full bg-emerald-500"></span>
                    <div class="font-semibold text-gray-900">{{ ucfirst($event->action) }}</div>
                    <span class="text-sm text-gray-600">by {{ $event->user?->name ?? 'System' }}</span>
                </div>
                <div class="text-sm text-gray-500">{{ $event->created_at?->diffForHumans() }}</div>
            </div>
            @if($event->notes)
                <p class="mt-2 text-gray-700">{{ $event->notes }}</p>
            @endif
            @if(!empty($event->evidence_paths))
                <div class="mt-3 flex flex-wrap gap-2">
                    @foreach($event->evidence_paths as $file)
                        <a href="{{ Storage::url($file) }}" target="_blank" rel="noreferrer" class="inline-flex items-center gap-2 rounded border border-emerald-200 bg-emerald-50 px-3 py-1 text-sm text-emerald-700 hover:bg-emerald-100">
                            <span class="text-[10px] font-bold tracking-wide">FILE</span>
                            <span>{{ basename($file) }}</span>
                        </a>
                    @endforeach
                </div>
            @endif
        </div>
    @empty
        <p class="text-sm text-gray-600">No dispute activity yet.</p>
    @endforelse
</div>
