<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Provider Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="font-semibold mb-4">Recent Services</h3>
                    <div class="grid md:grid-cols-2 gap-4">
                        @forelse($services as $service)
                            <div class="p-4 border rounded-lg">
                                <p class="text-sm text-gray-500">{{ $service->category?->name }}</p>
                                <p class="font-semibold">{{ $service->title }}</p>
                                <p class="text-sm text-gray-600">Mode: {{ $service->booking_mode }} · {{ $service->delivery_mode }}</p>
                            </div>
                        @empty
                            <p class="text-gray-500">No services yet.</p>
                        @endforelse
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="font-semibold mb-4">Recent Bookings</h3>
                    <div class="space-y-2">
                        @forelse($bookings as $booking)
                            <div class="flex justify-between border rounded-lg p-3">
                                <div>
                                    <p class="font-semibold">{{ $booking->service?->title }}</p>
                                    <p class="text-sm text-gray-600">{{ $booking->customer?->name }} · {{ $booking->status }}</p>
                                    <x-dashboard.timeline :booking="$booking"/>
                                </div>
                                <div class="text-sm text-gray-600 text-right">
                                    <p>${{ number_format($booking->amount, 2) }} {{ $booking->currency }}</p>
                                    <p>{{ optional($booking->scheduled_start)->format('M d, H:i') }}</p>
                                    <div class="mt-2 flex gap-2 justify-end">
                                        <form method="POST" action="{{ route('bookings.approve', $booking) }}">
                                            @csrf
                                            <button class="text-xs text-emerald-600">Approve</button>
                                        </form>
                                        <form method="POST" action="{{ route('bookings.reject', $booking) }}">
                                            @csrf
                                            <button class="text-xs text-rose-600">Reject</button>
                                        </form>
                                        <a href="{{ route('provider.bookings.messages', $booking) }}" class="text-xs text-indigo-600">Messages</a>
                                    </div>
                                    <form method="POST" action="{{ route('bookings.proposal', $booking) }}" class="mt-2 flex items-center gap-2">
                                        @csrf
                                        <input type="datetime-local" name="slot_start" class="border rounded px-2 py-1 text-xs" required>
                                        <button class="text-xs text-amber-600">Propose new time</button>
                                    </form>
                                </div>
                            </div>
                        @empty
                            <p class="text-gray-500">No bookings yet.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
