# Payment Flow Notes

- Gateways supported: Stripe, PayPal, Paystack via `PaymentGatewayInterface` and drivers in `app/Services/Payments`.
- Webhooks: `/api/webhooks/payments/{gateway}`. Set webhook secrets in `.env`.
- Initiation: customer selects gateway on `/bookings/{booking}/pay`; `PaymentService::initiate()` sets booking to `pending_payment`, records deposit, and leaves status as `pending_provider_approval` for approval-mode services.
- Captures: On webhook `captured`, escrow hold is created and instant bookings are auto-confirmed. Release handled via `PaymentService::releaseEscrow`.
- TODOs for production:
  - Implement real payment intent/redirect/SDK flows in each driver (create PaymentIntent/order/session and return client_secret/redirect URL).
  - Add confirmation/status page that reads payment payload (client_secret/approval URLs) to drive front-end checkout (see `payments.status` view).
  - Add UI to handle redirects/3DS confirmations and display payment status.
  - Implement refunds/chargebacks in drivers; wire admin actions for partial/full refunds.
  - Secure webhook IP/signature checks; log payloads (webhook_events).
  - Payout flows: integrate provider payout or bank transfers per gateway; currently stubbed.
