## Ops Checklist

- Queues: run `php artisan queue:work` under supervisor; ensure `QUEUE_CONNECTION` is not sync in production.
- Scheduler: cron `* * * * * php /path/to/artisan schedule:run >> /dev/null 2>&1`.
- Backups: daily DB backup and offsite storage.
- Monitoring: error tracking, uptime checks, log rotation.
- Webhooks: ensure `/api/webhooks/payments/{gateway}` reachable; set secrets.
- Security: enforce HTTPS, rotate app key on first deploy, restrict admin to strong creds, keep packages updated.
- Storage permissions: `storage/` and `bootstrap/cache/` writable; `php artisan storage:link`.
