# Deployment & Ops Checklist

- **Environment**: set `APP_URL`, `APP_ENV=production`, `APP_KEY`, `APP_DEBUG=false`, `APP_TIMEZONE`.
- **Database**: configure MySQL credentials; run `php artisan migrate --force`.
- **Queues**: set `QUEUE_CONNECTION=database|redis`; run `php artisan queue:work --daemon` (supervised).
- **Scheduler**: cron `* * * * * php /path/to/artisan schedule:run >> /dev/null 2>&1`.
- **Cache/Session**: use Redis or database in production; run `php artisan config:cache route:cache`.
- **Storage**: ensure `storage/` and `bootstrap/cache/` writable; symlink `php artisan storage:link`.
- **Mail**: configure SMTP in `.env`; set sender name/address.
- **Payments**: set gateway keys and webhook secrets (`STRIPE_WEBHOOK_SECRET`, etc.), expose `/api/webhooks/payments/{gateway}` publicly.
- **Calendar (Google)**: populate `GOOGLE_CLIENT_ID`, `GOOGLE_CLIENT_SECRET`, `GOOGLE_REDIRECT_URI`; implement OAuth exchange in `CalendarController` / `GoogleCalendarService` (see docs/CALENDAR_INTEGRATION.md).
- **Monitoring**: configure logging channel, add error monitoring, and backup DB regularly.
