## Google Calendar Integration (planned)

This app includes placeholders to integrate Google Calendar for providers:

- `.env` keys: `GOOGLE_CLIENT_ID`, `GOOGLE_CLIENT_SECRET`, `GOOGLE_REDIRECT_URI` (defaults to `/provider/calendar/callback`).
- Config: `config/services.php` has a `google` entry.
- Tokens are stored in `service_calendar_tokens` (model `ServiceCalendarToken`).
- Placeholder views: `resources/views/calendar/connect.blade.php` and `calendar/callback.blade.php`.
- Service stub: `App\Services\Calendar\GoogleCalendarService` with methods `exchangeAuthCode()` and `fetchBusySlots()`.
- Availability filtering will skip slots that overlap busy times when a token exists.

To finish integration:
1) Use Google OAuth (e.g., Socialite or google/apiclient) to redirect providers to Google consent and handle the callback at `/provider/calendar/callback`.
2) In the callback, call `GoogleCalendarService::exchangeAuthCode($code)` to exchange the `code` for tokens, then store them in `ServiceCalendarToken`.
3) Implement `fetchBusySlots` using Google's FreeBusy endpoint (method stub exists) to return busy periods; ensure proper timezone handling.
4) Optionally create events on confirmed bookings with the Google Calendar API, storing the event ID in `metadata`.
5) Secure webhooks or polling as needed to keep busy data fresh.

### Event creation
- `GoogleCalendarService::createEvent` will attempt to create events on confirmed bookings when a provider token exists. Ensure tokens are valid and consider handling API responses and storing event IDs in booking metadata for updates/cancellations.
- `GoogleCalendarService::cancelEvent` deletes events; used on cancel/reschedule when an event ID is present.
