<?php

namespace Database\Factories;

use App\Models\Dispute;
use App\Models\DisputeEvent;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<DisputeEvent>
 */
class DisputeEventFactory extends Factory
{
    protected $model = DisputeEvent::class;

    public function definition(): array
    {
        return [
            'dispute_id' => Dispute::factory(),
            'user_id' => User::factory(),
            'action' => 'opened',
            'notes' => $this->faker->sentence(),
            'metadata' => [],
        ];
    }
}
