<?php

namespace App\Services\Payments;

use App\Models\PaymentGateway;
use InvalidArgumentException;

class PaymentGatewayManager
{
    /**
     * Resolve a gateway driver by name.
     */
    public function driver(string $name): PaymentGatewayInterface
    {
        return match ($name) {
            'stripe' => app(StripeGateway::class),
            'paypal' => app(PayPalGateway::class),
            'paystack' => app(PaystackGateway::class),
            default => throw new InvalidArgumentException("Payment gateway [{$name}] is not supported."),
        };
    }

    public function fromModel(PaymentGateway $gateway): PaymentGatewayInterface
    {
        return $this->driver($gateway->name);
    }
}
