<?php

namespace App\Services\Payments;

use App\Models\Booking;
use App\Models\Payment;
use App\Models\PaymentGateway;
use Illuminate\Http\Request;

interface PaymentGatewayInterface
{
    public function createPaymentIntent(Booking $booking): Payment;

    public function handleWebhook(Request $request, PaymentGateway $gateway): ?Payment;

    public function capture(Payment $payment): Payment;

    public function refund(Payment $payment, float $amount): Payment;

    public function payout(Payment $payment): bool;
}
