<?php

namespace App\Policies;

use App\Models\Booking;
use App\Models\User;

class BookingPolicy
{
    public function view(User $user, Booking $booking): bool
    {
        return $user->id === $booking->customer_id || $user->id === $booking->provider_id || $user->hasRole('admin');
    }

    public function update(User $user, Booking $booking): bool
    {
        if ($user->hasRole('admin')) {
            return true;
        }

        if ($user->hasRole('provider') && $booking->provider_id === $user->id) {
            return true;
        }

        if ($user->hasRole('customer') && $booking->customer_id === $user->id) {
            return true;
        }

        return false;
    }

    public function create(User $user): bool
    {
        return $user->hasRole('customer');
    }
}
