<?php

namespace App\Observers;

use App\Models\AuditLog;
use App\Models\Booking;
use Illuminate\Support\Facades\Request;

class BookingObserver
{
    public function updated(Booking $booking): void
    {
        AuditLog::create([
            'user_id' => auth()->id(),
            'auditable_type' => Booking::class,
            'auditable_id' => $booking->id,
            'action' => 'updated',
            'metadata' => [
                'changes' => $booking->getChanges(),
            ],
            'ip_address' => Request::ip(),
        ]);
    }
}
