<?php

namespace App\Notifications\Channels;

use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Log;

class SmsChannel
{
    public function send(mixed $notifiable, Notification $notification): void
    {
        if (! method_exists($notification, 'toSms')) {
            return;
        }

        $message = $notification->toSms($notifiable);

        // TODO: integrate real SMS provider (e.g., Twilio). For now, log message.
        Log::info('SMS notification', [
            'to' => $notifiable->phone ?? 'unknown',
            'message' => $message,
        ]);
    }
}
