<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PaymentGateway extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'display_name',
        'mode',
        'enabled',
        'credentials',
        'supported_currencies',
        'webhook_secret',
    ];

    protected $casts = [
        'enabled' => 'bool',
        'credentials' => 'array',
        'supported_currencies' => 'array',
    ];

    public function payments(): HasMany
    {
        return $this->hasMany(Payment::class);
    }
}
