<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AvailabilityRule extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'service_id',
        'day_of_week',
        'start_time',
        'end_time',
        'timezone',
        'breaks',
        'min_notice_minutes',
        'max_bookings_per_day',
        'buffer_before_minutes',
        'buffer_after_minutes',
        'is_default',
    ];

    protected $casts = [
        'breaks' => 'array',
        'is_default' => 'bool',
    ];

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }

    public function provider(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
