<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureInstalled
{
    public function handle(Request $request, Closure $next): Response
    {
        $installed = app()->environment('testing')
            || file_exists(storage_path('app/installed.lock'))
            || config('app.installed');

        if (! $installed && ! $request->is('install*')) {
            return redirect()->route('install.welcome');
        }

        if ($installed && $request->is('install*')) {
            abort(403, 'Application already installed.');
        }

        return $next($request);
    }
}
