<?php

namespace App\Http\Controllers;

use App\Models\Page;
use Illuminate\Support\Facades\Schema;

class PageController extends Controller
{
    public function home()
    {
        if (! Schema::hasTable('pages')) {
            return view('welcome');
        }

        $page = Page::where(function ($query) {
            $query->where('template', 'home')
                ->orWhere('slug', 'home');
        })->where('published', true)->first();

        if (! $page) {
            return view('welcome');
        }

        return view('pages.show', compact('page'));
    }

    public function show(string $slug)
    {
        $page = Page::where('slug', $slug)->where('published', true)->firstOrFail();

        return view('pages.show', compact('page'));
    }
}
