<?php

namespace App\Filament\Widgets;

use App\Models\Booking;
use App\Models\Dispute;
use App\Models\Service;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class OverviewStats extends BaseWidget
{
    protected function getStats(): array
    {
        $revenue = Booking::whereIn('status', ['confirmed', 'completed_pending_release', 'released'])->sum('amount');

        return [
            Stat::make('Bookings', Booking::count())
                ->description('Total bookings'),
            Stat::make('Published Services', Service::where('status', 'published')->count()),
            Stat::make('Open Disputes', Dispute::where('status', 'open')->count())
                ->description('Requires attention')
                ->color('danger'),
            Stat::make('Gross Volume', '$'.number_format($revenue, 2))
                ->description('Confirmed/Released'),
        ];
    }
}
